# WT Event Filter Module for Webtrees

A Webtrees 2.2+ custom module for intelligent filtering of event types on individual pages.

## 📋 Table of Contents

- [About the Module](#about-the-module)
- [Features](#features)
- [System Requirements](#system-requirements)
- [Installation](#installation)
- [Usage](#usage)
- [Filter Logic](#filter-logic)
- [Compatibility](#compatibility)
- [Customization](#customization)
- [Troubleshooting](#troubleshooting)
- [Supported Languages](#supported-languages)
- [Support](#support)
- [License](#license)

---

## 🎯 About the Module

The **WT Event Filter Module** allows you to selectively and intelligently filter events on individual pages. With automatic type detection, OR logic, and localStorage persistence, navigating through extensive event lists becomes child's play.

**Developed by:** Thomas Schiller (with the help of AI Sonnet)  
**Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)  
**Version:** 2.2.4.0.0

---

## ✨ Features

- ✅ **Client-side filtering** - Events are filtered without server reload
- ✅ **Automatic type detection** - Only actually existing event types are shown as filters
- ✅ **OR logic** - Multiple selected filters show all matching events
- ✅ **Persistence** - Filter selection is saved per person in localStorage
- ✅ **Vesta compatibility** - Works with standard "Facts and events" and the Vesta Facts and events module
- ✅ **Accessible** - Proper labels, keyboard navigation, aria-attributes
- ✅ **Responsive** - Adapts to different screen sizes
- ✅ **Multilingual** - German, English, French, Hungarian
- ✅ **No dependencies** - Pure JavaScript, no jQuery required

---

## 💻 System Requirements

- **Webtrees:** Version 2.2.1 or higher (tested with 2.2.4)
- **PHP:** Version 8.0 or higher (recommended: 8.3+)
- **Browser:** All modern browsers with JavaScript enabled
- **FTP Access:** For uploading module files

---

## 📦 Installation

### Step 1: Download Module

Download the module from [https://wt-module.schitho.at](https://wt-module.schitho.at) and extract it.

### Step 2: Upload Files

Upload the complete `wt-event-filter` folder to the `/modules_v4/` directory of your Webtrees installation.

The structure should look like this:

```
webtrees/
└── modules_v4/
    └── wt-event-filter/
        ├── module.php
        └── resources/
            ├── lang/
            │   ├── de.php
            │   ├── en-GB.php
            │   ├── fr.php
            │   └── hu.php
            ├── css/
            │   └── filter.css
            └── js/
                └── filter.js
```

### Step 3: Enable Module

1. Log in to Webtrees as administrator
2. Navigate to **Control Panel** → **Modules** → **All Modules**
3. Search for **"WT Event Filter"**
4. Enable the module by clicking the switch

**Done!** The module is immediately ready to use – no further configuration needed!

---

## 🎨 Usage

### Basic Usage

1. Open an individual page in Webtrees
2. A filter bar with checkboxes automatically appears above the events list
3. Select one or more event types by clicking them
4. The events list is immediately filtered
5. Click "Clear all" to reset the filter

### Examples

**No selection:**
- ✓ All events are displayed

**One selection (e.g., "Birth"):**
- ✓ Only birth events are displayed
- ✗ All other events are hidden

**Multiple selections (e.g., "Occupation" + "Education"):**
- ✓ All occupation events are displayed
- ✓ All education events are displayed
- ✗ All other events are hidden

---

## 🔄 Filter Logic

### OR Connection

The module uses **OR logic**: When you select multiple event types, all events matching **at least one** of the selected types are displayed.

**Example:** When selecting both "Birth" AND "Death", both all birth events and all death events are displayed.

### Persistence (Storage)

Your filter selection is **automatically saved per person** in your browser's localStorage. When you visit the same individual page later, your previous selection is automatically restored.

**Note:** Storage is local to your browser. When using private/incognito mode or clearing browser data, the selection will be lost.

---

## 🔧 Compatibility

The module works with:

- ✓ Standard Webtrees "Facts and events" tab
- ✓ Vesta Facts and events module
- ✓ All common themes
- ✓ Desktop, tablet, and smartphone

**Tested browsers:**
- Chrome/Edge (Chromium) 90+
- Firefox 88+
- Safari 14+
- Mobile Safari (iOS 14+)
- Chrome Mobile (Android 10+)

---

## ⚙️ Customization

### Adjust DOM Selectors

If the module doesn't work with your theme or other modules, you can adjust the DOM selectors in `resources/js/filter.js`.

The file contains configurable selectors for:
- Tab container (tabRoot)
- Event rows (eventRow)
- Type label elements (typeLabel)

**Note:** Contact support if you need help with customization.

### Adjust Styling

The styling can be customized in `resources/css/filter.css`. All classes start with `wt-event-filter-` to avoid conflicts.

---

## 🔧 Troubleshooting

### Filter Doesn't Appear

**Checklist:**
1. Is the module enabled? → "Control Panel → Modules → All Modules"
2. Is JavaScript enabled in the browser?
3. Does the individual page have events?
4. Check browser console (F12) for error messages

### Filter Doesn't Work with My Theme

The module uses configurable DOM selectors. If you have problems:
1. Open the browser console (F12)
2. Look for warnings like "Could not find facts tab container"
3. Contact support with screenshots of the errors

### Filter Selection Not Saved

The module uses localStorage. Make sure that:
- The browser supports localStorage (all modern browsers do)
- No browser extensions block localStorage
- The browser is not in private/incognito mode
- Cookies and site data are not deleted after each close

### Events Are Not Filtered

**Possible causes:**
- JavaScript error → Check browser console (F12)
- Theme incompatibility → Contact support
- Another module causing conflict → Test by temporarily disabling other modules

---

## 🌍 Supported Languages

The module is available in the following languages:

- 🇩🇪 **Deutsch** (de.php)
- 🇬🇧 **English** (en-GB.php)
- 🇫🇷 **Français** (fr.php)
- 🇭🇺 **Magyar** (hu.php)

The language file is automatically loaded based on the Webtrees language setting.

---

## 📞 Support

### Contact

If you have questions, problems, or suggestions for improvement:

- **Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)
- **E-Mail:** [info@wt-module.schitho.at](mailto:info@wt-module.schitho.at)
- **Author:** Thomas Schiller (with the help of AI Sonnet)

### Helpful Resources

- [Webtrees Documentation](https://webtrees.net/)
- [Webtrees Wiki](https://wiki.genealogy.net/Webtrees_Handbuch)
- [Webtrees Forum](https://www.webtrees.net/forums/)

---

## 📜 License

This module is free software and is published under the **GNU General Public License v3.0**.

```
webtrees: online genealogy
Copyright (C) 2025 webtrees development team

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

The complete license can be found at: [https://www.gnu.org/licenses/gpl-3.0.html](https://www.gnu.org/licenses/gpl-3.0.html)

---

## 🙏 Acknowledgments

- **Webtrees Team** - For the great genealogy software
- **JustCarmen** - For inspiration through other Webtrees modules
- **Anthropic (Claude Sonnet 4.5)** - For support during development

---

## 📝 Changelog

### Version 2.2.4.0.0
- ✨ Updated version numbering to 2.2.4.0.0
- ✨ Updated author information with multilingual support
- ✨ Added module website URL: https://wt-module.schitho.at
- ✨ Enhanced language files with author translations
- 🔧 Improved module metadata and documentation

### Version 1.0.1
- ✨ Improved language integration directly from Webtrees
- ✨ Separate language files for better maintainability
- ✨ Increased CSS specificity through body prefix
- ✨ boot() method for future extensions
- 🐛 Description now translated

### Version 1.0.0
- Initial release
- Client-side filtering with OR logic
- localStorage persistence per person
- Vesta Facts and events compatibility
- Responsive design
- Dark mode support

---

**Good luck with the Event Filter Module!** 🎉
