# WT Event Filter Modul für Webtrees

Ein Webtrees 2.2+ Custom-Modul zum intelligenten Filtern von Ereignistypen auf Personenseiten.

## 📋 Inhaltsverzeichnis

- [Über das Modul](#über-das-modul)
- [Funktionen](#funktionen)
- [Systemanforderungen](#systemanforderungen)
- [Installation](#installation)
- [Verwendung](#verwendung)
- [Filterlogik](#filterlogik)
- [Kompatibilität](#kompatibilität)
- [Anpassung](#anpassung)
- [Fehlerbehebung](#fehlerbehebung)
- [Unterstützte Sprachen](#unterstützte-sprachen)
- [Support](#support)
- [Lizenz](#lizenz)

---

## 🎯 Über das Modul

Das **WT Event Filter Modul** ermöglicht es dir, Ereignisse auf Personenseiten gezielt und intelligent zu filtern. Mit automatischer Typ-Erkennung, ODER-Logik und localStorage-Persistenz wird die Navigation durch umfangreiche Ereignislisten zum Kinderspiel.

**Entwickelt von:** Thomas Schiller (mit Hilfe der KI Sonnet)  
**Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)  
**Version:** 2.2.4.0.0

---

## ✨ Funktionen

- ✅ **Client-seitige Filterung** - Ereignisse werden ohne Server-Reload gefiltert
- ✅ **Automatische Typ-Erkennung** - Nur tatsächlich vorhandene Ereignistypen werden als Filter angezeigt
- ✅ **ODER-Logik** - Mehrere ausgewählte Filter zeigen alle passenden Ereignisse
- ✅ **Persistenz** - Die Filterauswahl wird pro Person im localStorage gespeichert
- ✅ **Vesta-Kompatibilität** - Funktioniert mit Standard "Facts and events" und dem Vesta Facts and events Modul
- ✅ **Barrierefrei** - Proper labels, keyboard navigation, aria-attributes
- ✅ **Responsiv** - Passt sich verschiedenen Bildschirmgrößen an
- ✅ **Mehrsprachig** - Deutsch, Englisch, Französisch, Ungarisch
- ✅ **Keine Abhängigkeiten** - Pure JavaScript, kein jQuery erforderlich

---

## 💻 Systemanforderungen

- **Webtrees:** Version 2.2.1 oder höher (getestet mit 2.2.4)
- **PHP:** Version 8.0 oder höher (empfohlen: 8.3+)
- **Browser:** Alle modernen Browser mit JavaScript aktiviert
- **FTP-Zugang:** Zum Hochladen der Modul-Dateien

---

## 📦 Installation

### Schritt 1: Modul herunterladen

Lade das Modul von [https://wt-module.schitho.at](https://wt-module.schitho.at) herunter und entpacke es.

### Schritt 2: Dateien hochladen

Lade den kompletten Ordner `wt-event-filter` in das Verzeichnis `/modules_v4/` deiner Webtrees-Installation hoch.

Die Struktur sollte wie folgt aussehen:

```
webtrees/
└── modules_v4/
    └── wt-event-filter/
        ├── module.php
        └── resources/
            ├── lang/
            │   ├── de.php
            │   ├── en-GB.php
            │   ├── fr.php
            │   └── hu.php
            ├── css/
            │   └── filter.css
            └── js/
                └── filter.js
```

### Schritt 3: Modul aktivieren

1. Melde dich als Administrator in Webtrees an
2. Gehe zu **Verwaltung** → **Module** → **Alle Module**
3. Suche nach **"WT Event Filter"**
4. Aktiviere das Modul durch Anklicken des Schalters

**Fertig!** Das Modul ist sofort einsatzbereit – keine weitere Konfiguration nötig!

---

## 🎨 Verwendung

### Grundlegende Nutzung

1. Öffne eine Personenseite in Webtrees
2. Oberhalb der Ereignisliste erscheint automatisch eine Filterleiste mit Checkboxen
3. Wähle einen oder mehrere Ereignistypen durch Anklicken aus
4. Die Ereignisliste wird sofort gefiltert
5. Klicke "Alle löschen", um den Filter zurückzusetzen

### Beispiele

**Keine Auswahl:**
- ✓ Alle Ereignisse werden angezeigt

**Eine Auswahl (z.B. "Geburt"):**
- ✓ Nur Geburts-Ereignisse werden angezeigt
- ✗ Alle anderen Ereignisse sind ausgeblendet

**Mehrere Auswahlen (z.B. "Beruf" + "Ausbildung"):**
- ✓ Alle Berufs-Ereignisse werden angezeigt
- ✓ Alle Ausbildungs-Ereignisse werden angezeigt
- ✗ Alle anderen Ereignisse sind ausgeblendet

---

## 🔄 Filterlogik

### ODER-Verknüpfung

Das Modul verwendet eine **ODER-Logik**: Wenn du mehrere Ereignistypen auswählst, werden alle Ereignisse angezeigt, die **mindestens einem** der ausgewählten Typen entsprechen.

**Beispiel:** Bei Auswahl von "Geburt" UND "Tod" werden sowohl alle Geburts- als auch alle Todes-Ereignisse angezeigt.

### Persistenz (Speicherung)

Deine Filterauswahl wird **automatisch pro Person** im localStorage deines Browsers gespeichert. Wenn du die gleiche Personenseite später wieder besuchst, wird deine vorherige Auswahl automatisch wiederhergestellt.

**Hinweis:** Die Speicherung erfolgt lokal in deinem Browser. Bei Nutzung des privaten/Inkognito-Modus oder beim Löschen der Browser-Daten geht die Auswahl verloren.

---

## 🔧 Kompatibilität

Das Modul funktioniert mit:

- ✓ Standard Webtrees "Facts and events" Tab
- ✓ Vesta Facts and events Modul
- ✓ Allen gängigen Themes
- ✓ Desktop, Tablet und Smartphone

**Getestete Browser:**
- Chrome/Edge (Chromium) 90+
- Firefox 88+
- Safari 14+
- Mobile Safari (iOS 14+)
- Chrome Mobile (Android 10+)

---

## ⚙️ Anpassung

### DOM-Selektoren anpassen

Falls das Modul mit deinem Theme oder anderen Modulen nicht funktioniert, kannst du die DOM-Selektoren in `resources/js/filter.js` anpassen.

Die Datei enthält konfigurierbare Selektoren für:
- Tab-Container (tabRoot)
- Ereignis-Zeilen (eventRow)
- Typ-Label Elemente (typeLabel)

**Hinweis:** Kontaktiere den Support, wenn du Hilfe bei der Anpassung benötigst.

### Styling anpassen

Das Styling kann in `resources/css/filter.css` angepasst werden. Alle Klassen beginnen mit `wt-event-filter-` zur Vermeidung von Konflikten.

---

## 🔧 Fehlerbehebung

### Filter erscheint nicht

**Checkliste:**
1. Ist das Modul aktiviert? → "Verwaltung → Module → Alle Module"
2. Ist JavaScript im Browser aktiviert?
3. Hat die Personenseite Ereignisse?
4. Browser-Konsole prüfen (F12) auf Fehlermeldungen

### Filter funktioniert nicht mit meinem Theme

Das Modul verwendet konfigurierbare DOM-Selektoren. Bei Problemen:
1. Öffne die Browser-Konsole (F12)
2. Suche nach Warnungen wie "Could not find facts tab container"
3. Kontaktiere den Support mit Screenshots der Fehler

### Filterauswahl wird nicht gespeichert

Das Modul verwendet localStorage. Stelle sicher, dass:
- Der Browser localStorage unterstützt (alle modernen Browser tun dies)
- Keine Browser-Erweiterungen localStorage blockieren
- Der Browser nicht im privaten/Inkognito-Modus läuft
- Cookies und Website-Daten nicht nach jedem Schließen gelöscht werden

### Ereignisse werden nicht gefiltert

**Mögliche Ursachen:**
- JavaScript-Fehler → Browser-Konsole prüfen (F12)
- Theme-Inkompatibilität → Support kontaktieren
- Anderes Modul verursacht Konflikt → Andere Module testweise deaktivieren

---

## 🌍 Unterstützte Sprachen

Das Modul ist in folgenden Sprachen verfügbar:

- 🇩🇪 **Deutsch** (de.php)
- 🇬🇧 **English** (en-GB.php)
- 🇫🇷 **Français** (fr.php)
- 🇭🇺 **Magyar** (hu.php)

Die Sprachdatei wird automatisch basierend auf der Webtrees-Spracheinstellung geladen.

---

## 📞 Support

### Kontakt

Wenn du Fragen, Probleme oder Verbesserungsvorschläge hast:

- **Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)
- **E-Mail:** [info@wt-module.schitho.at](mailto:info@wt-module.schitho.at)
- **Autor:** Thomas Schiller (mit Hilfe der KI Sonnet)

### Hilfreiche Ressourcen

- [Webtrees Dokumentation](https://webtrees.net/)
- [Webtrees Wiki](https://wiki.genealogy.net/Webtrees_Handbuch)
- [Webtrees Forum](https://www.webtrees.net/forums/)

---

## 📜 Lizenz

Dieses Modul ist freie Software und wird unter der **GNU General Public License v3.0** veröffentlicht.

```
webtrees: online genealogy
Copyright (C) 2025 webtrees development team

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

Die vollständige Lizenz findest du unter: [https://www.gnu.org/licenses/gpl-3.0.html](https://www.gnu.org/licenses/gpl-3.0.html)

---

## 🙏 Danksagungen

- **Webtrees Team** - Für die großartige Genealogie-Software
- **JustCarmen** - Für Inspiration durch andere Webtrees-Module
- **Anthropic (Claude Sonnet 4.5)** - Für die Unterstützung bei der Entwicklung

---

## 📝 Changelog

### Version 2.2.4.0.0
- ✨ Versionsnummer auf 2.2.4.0.0 aktualisiert
- ✨ Autor-Informationen mit mehrsprachiger Unterstützung aktualisiert
- ✨ Modul-Website-URL hinzugefügt: https://wt-module.schitho.at
- ✨ Sprachdateien mit Autor-Übersetzungen erweitert
- 🔧 Verbesserte Modul-Metadaten und Dokumentation

### Version 1.0.1
- ✨ Verbesserte Spracheinbindung direkt von Webtrees
- ✨ Separate Sprachdateien für bessere Wartbarkeit
- ✨ CSS-Spezifität erhöht durch body-Präfix
- ✨ boot() Methode für zukünftige Erweiterungen
- 🐛 Beschreibung jetzt übersetzt

### Version 1.0.0
- Initiale Veröffentlichung
- Client-seitige Filterung mit ODER-Logik
- localStorage-Persistenz pro Person
- Vesta Facts and events Kompatibilität
- Responsive Design
- Dark Mode Support

---

**Viel Erfolg mit dem Event Filter Modul!** 🎉
