<?php

declare(strict_types=1);

namespace MyVendor\Webtrees\Module\BurialPlacesReport;

class NoteFormatter
{
    /**
     * Konvertiert Markdown-ähnliche Formatierung in HTML
     */
    public static function formatNote(string $text): string
    {
        // Text erst escapen für Sicherheit
        $text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
        
        // Markdown-Formatierungen anwenden (in dieser Reihenfolge wichtig!)
        
        // 1. ***fett und kursiv*** 
        $text = preg_replace('/\*\*\*(.+?)\*\*\*/', '<strong><em>$1</em></strong>', $text);
        $text = preg_replace('/___(.+?)___/', '<strong><em>$1</em></strong>', $text);
        
        // 2. **fett**
        $text = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $text);
        $text = preg_replace('/__(.+?)__/', '<strong>$1</strong>', $text);
        
        // 3. *kursiv*
        $text = preg_replace('/\*(.+?)\*/', '<em>$1</em>', $text);
        $text = preg_replace('/_(.+?)_/', '<em>$1</em>', $text);
        
        // 4. Links [Text](URL)
        $text = preg_replace('/\[([^\]]+)\]\(([^\)]+)\)/', '<a href="$2" target="_blank" rel="noopener">$1</a>', $text);
        
        // 5. Einfache Links (nur URL)
        $text = preg_replace(
            '/(https?:\/\/[^\s<]+)/',
            '<a href="$1" target="_blank" rel="noopener">$1</a>',
            $text
        );
        
        // 6. Zeilenumbrüche
        $text = nl2br($text);
        
        return $text;
    }
}
