# Burial Places Module for Webtrees

A Webtrees 2.2+ custom module for intelligent analysis and display of burial locations, grouped by cemeteries and institutions.

## 📋 Table of Contents

- [About the Module](#about-the-module)
- [Features](#features)
- [System Requirements](#system-requirements)
- [Installation](#installation)
- [Usage](#usage)
- [Configuration](#configuration)
- [Filter Logic](#filter-logic)
- [CSV Export](#csv-export)
- [**🎨 Icon and Menu Customization**](#icon-and-menu-customization) ⭐ NEW
- [Compatibility](#compatibility)
- [Supported Languages](#supported-languages)
- [Support](#support)
- [License](#license)

---

## 🎯 About the Module

The **Burial Places Module** analyzes all burial events (BURI) in your family tree and groups them by burial locations and cemeteries or institutions. What makes it special: The module intelligently searches different GEDCOM fields (AGNC, PLAC, NOTE) for cemetery information - configurable for different genealogy programs.

**Developed by:** Thomas Schiller (with the help of AI Sonnet)  
**Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)  
**Version:** 2.2.4.1.2

---

## ✨ Features

- ✅ **Intelligent Cemetery Detection** - Automatically searches AGNC, PLAC, or NOTE for cemetery information
- ✅ **Configurable Fallback Order** - You determine the order in which fields are searched
- ✅ **Keyword Filter** - Define keywords (e.g., "Cemetery", "Friedhof") for detecting cemeteries in PLAC and NOTE
- ✅ **Flexible Filtering** - Filter by burial location, cemetery/institution, or show only entries with/without cemetery information
- ✅ **Sorting Options** - Sort by location or by cemetery/institution
- ✅ **CSV Export** - Export the complete list with all details
- ✅ **Diagnostic Mode** - Shows which GEDCOM field the cemetery information comes from (AGNC/PLAC/NOTE)
- ✅ **Always Show AGNC Field** - Option to make the cemetery field (institution) always visible in the burial editor
- ✅ **Customizable Menu Icons** - Icons and layout individually customizable for each theme
- ✅ **Multilingual** - German, English, French, Hungarian
- ✅ **Tree-specific Settings** - Each family tree can be configured individually

---

## 💻 System Requirements

- **Webtrees:** Version 2.2.1 or higher (tested with 2.2.4)
- **PHP:** Version 8.0 or higher (recommended: 8.3+)
- **Browser:** All modern browsers with JavaScript enabled
- **FTP Access:** For uploading module files

---

## 📦 Installation

### Step 1: Download the Module

Download the module from [https://wt-module.schitho.at](https://wt-module.schitho.at) and extract it.

### Step 2: Upload Files

Upload the complete folder `burial-places-report` to the `/modules_v4/` directory of your Webtrees installation.

The structure should look like this:

```
webtrees/
└── modules_v4/
    └── burial-places-report/
        ├── module.php
        ├── module_helper.php
        └── resources/
            ├── lang/
            │   ├── de.php
            │   ├── en-GB.php
            │   ├── fr.php
            │   └── hu.php
            ├── views/
            │   ├── admin.phtml
            │   ├── admin-tree-select.phtml
            │   └── list-page.phtml
            ├── css/
            │   ├── menu-icons.webtrees.css
            │   ├── menu-icons.colors.css
            │   ├── menu-icons.fab.css
            │   ├── menu-icons.minimal.css
            │   ├── menu-icons.clouds.css
            │   ├── menu-icons.xenea.css
            │   └── menu-icons.universal.css
            └── icons/
                └── (various SVG icons)
```

### Step 3: Activate the Module

1. Log in to Webtrees as administrator
2. Go to **Control panel** → **Modules** → **All modules**
3. Search for **"Burial Places Report"**
4. Activate the module by clicking the switch

### Step 4: Configure the Module

1. Go to **Control panel** → **Modules** → **Lists**
2. Click on the gear icon (settings) for "Burial Places"
3. Select the desired family tree
4. Configure the settings according to your needs

**Done!** The module is now ready to use!

---

## 🎨 Usage

### Basic Usage

1. Go to **Lists** → **Burial Places** in the main menu
2. Optionally select filters:
   - Burial location (e.g., "Vienna")
   - Cemetery/Institution (e.g., "Central Cemetery")
   - Only entries with/without cemetery information
3. Choose sorting: By location or by cemetery/institution
4. Click "Create list"
5. Results are displayed grouped by burial location and cemetery
6. Optional: Export the list as a CSV file

### Display of Results

The list shows:
- **Grouping:** By burial location and cemetery/institution
- **Personal Data:** Name, birth, death, age
- **Burial Date:** Date of burial
- **Count:** How many people are buried at each location/cemetery

---

## ⚙️ Configuration

### Admin Settings

Open the module settings via **Control panel** → **Modules** → **Lists** → **Burial Places** (gear icon).

#### 1. Cemetery Field in Event Editor

**Option:** "Always show cemetery field (institution) for burials"

When enabled, the AGNC field (institution) is always displayed in the burial editor and can be edited - even if no value has been entered yet. This facilitates data entry.

#### 2. Order for Value Determination

The module can search for cemetery information in three different GEDCOM fields:

- **AGNC** (Institution) - The specialized cemetery field
- **NOTE** (First line of the note) - When keywords match
- **PLAC** (Place name) - When keywords match

**Example order:**
1. First search in AGNC field
2. If empty: Check first line of NOTE (with keywords)
3. If empty: Check PLAC field (with keywords)

You can change the order via drag & drop.

#### 3. Cemetery Keywords

Define keywords that the module uses to identify cemeteries in PLAC and NOTE fields.

**Default keywords:**
```
Friedhof,Cemetery,Cimetière,Temető
```

**Format:** Comma-separated, without spaces

**Example:** If "Cemetery" is defined as a keyword and the PLAC field contains "Vienna, Central Cemetery", then "Vienna, Central Cemetery" is recognized as a cemetery.

#### 4. Diagnostic Mode

**Option:** "Show source tag (AGNC/NOTE/PLAC) in brackets"

When enabled, you see in brackets in the list which GEDCOM field the cemetery information comes from:
- (AGNC) - From the institution field
- (NOTE) - From the first line of a note
- (PLAC) - From the place field
- (NONE) - No information found

This helps you review and optimize your GEDCOM data.

#### 5. Reset to Default Values

With the "Reset to default values" button, you can reset all settings for the current tree to factory settings.

---

## 🔄 Filter Logic

### Intelligent Cemetery Detection

The module searches the GEDCOM data in the order you specify:

**1. AGNC Field (Institution):**
```gedcom
1 BURI
2 AGNC Central Cemetery Vienna
```
→ Direct value is taken

**2. NOTE Field (First line with keywords):**
```gedcom
1 BURI
2 NOTE St. Marx Cemetery, Group 15
```
→ If "Cemetery" is defined as a keyword, the first line is taken

**3. PLAC Field (With keywords):**
```gedcom
1 BURI
2 PLAC Vienna, Central Cemetery
```
→ If "Cemetery" or "Central Cemetery" is defined as a keyword, the place name is taken

### Burial Location Filter

In the frontend you can choose:
- **With and without cemetery information** - Shows all burials
- **Only with cemetery information** - Shows only entries where a cemetery was found
- **Only without cemetery information** - Shows only entries without a cemetery (for data maintenance)

---

## 📄 CSV Export

### Export Function

Click "Download as CSV" to export the current list.

**CSV Columns:**
1. Burial location
2. Cemetery/Institution
3. Name
4. Death date
5. Burial date
6. Address (from BURI → ADDR)
7. Note (from BURI → NOTE)
8. URL to person page

**Format:**
- Character set: UTF-8 with BOM
- Delimiter: Semicolon (;)
- Text delimiter: Quotation marks (")
- Filename: `burial-places-[TREE]-[DATE].csv`

**Example:** `burial-places-smith-2025-10-23.csv`

---

## 🎨 Icon and Menu Customization

### Overview: How the Icon System Works

The module uses **theme-specific CSS files** to optimally adapt icons and layout for each menu item to the respective Webtrees theme. The system works automatically:

1. **Automatic Theme Detection:** The module detects your active theme
2. **Load Theme-specific CSS:** It automatically loads the matching CSS file (e.g., `menu-icons.webtrees.css` for the Webtrees standard theme)
3. **Fallback Mechanism:** If no theme-specific file exists, `menu-icons.universal.css` is used

**Available Theme CSS Files:**
```
resources/css/
├── menu-icons.webtrees.css     → for Webtrees theme
├── menu-icons.colors.css       → for Colors theme
├── menu-icons.fab.css          → for FAB theme
├── menu-icons.minimal.css      → for Minimal theme
├── menu-icons.clouds.css       → for Clouds theme
├── menu-icons.xenea.css        → for Xenea theme
└── menu-icons.universal.css    → Fallback for all other themes
```

**Note on universal.css:**
This file uses **no theme class** (e.g., `.wt-theme-webtrees`), but only `.dropdown-item.menu-list-burial`. This makes it work with **all** themes, but it is **not suitable as a template** for your own theme-specific CSS files!

---

### ❌ Option 1: Display Menu Item WITHOUT Icon

If you want to display the menu item **without an icon**, there are two options:

#### Method A: Remove CSS File for Your Theme

1. Navigate to the module directory:
   ```
   /modules_v4/burial-places-report/resources/css/
   ```

2. Rename or delete the CSS file for your theme:
   ```
   menu-icons.webtrees.css  → menu-icons.webtrees.css.backup
   ```

3. Clear cache (Browser: Ctrl+F5)

**Result:** The menu item appears without icon with standard Webtrees formatting.

#### Method B: Disable Icon in CSS

1. Open the CSS file for your theme:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

2. Find the section with `::before` and change:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
     display: none;  /* ← Add this line */
   }
   ```

3. Adjust padding (optional) so the text is not indented:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
     padding: 0.40rem 1rem !important;  /* No padding-left for icon */
   }
   ```

4. Save the file and clear browser cache (Ctrl+F5)

---

### 🔧 Option 2: Customize Existing CSS Files

You can customize the layout, size, and position of the icon individually for each theme.

#### Step 1: Open CSS File for Your Theme

1. Identify your active theme (e.g., "webtrees")
2. Open the corresponding CSS file:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

#### Step 2: Customizable Parameters

The CSS files are extensively commented. Here are the most important parameters:

##### 📏 **Adjust Icon Size**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  width: 1.50em;   /* Icon width (default: 1.50em) */
  height: 1.50em;  /* Icon height (default: 1.50em) */
}
```
**Recommended values:** 0.8em (small) to 1.8em (large)

##### 📍 **Move Icon Horizontally**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.35em;  /* Distance from left edge (default: 0.35em) */
}
```
- **Smaller value** (e.g., 0.2em) = Icon further left
- **Larger value** (e.g., 0.6em) = Icon further right

##### 📍 **Move Icon Vertically**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  top: 32%;  /* Vertical position (default: 32%-40%) */
}
```
- **Smaller value** (e.g., 25%) = Icon higher
- **Larger value** (e.g., 45%) = Icon lower

##### 📐 **Line Height and Spacing**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.90 !important;  /* Line height (default: 1.5-2.0) */
  padding: 0rem 1rem 0.70rem 2.20em !important;  /* top right bottom left */
}
```
- **line-height:** Higher values = more space between lines
- **padding-left:** Should be at least 2.0em if icon is displayed

#### Step 3: Test Changes

1. Save the CSS file
2. Clear browser cache: **Ctrl+F5** (Windows) or **Cmd+Shift+R** (Mac)
3. Check the display in the menu

**Tip:** The CSS files contain a detailed quick guide with all customizable parameters at the end!

---

### 🎨 Option 3: Use Your Own Icon

You can replace the default icon with your own icon.

#### Supported Icon Formats

- **SVG** (recommended) - Scales perfectly at any size
- **PNG** - With transparent background, at least 64x64 pixels
- **WebP** - Modern alternative to PNG

#### Step 1: Prepare Icon File

1. Create or download an icon in **SVG** format
2. Name it meaningfully, e.g., `my-cemetery-icon.svg`

**Icon Size Recommendations:**
- **SVG:** Any size (automatically scaled)
- **PNG:** At least 64x64 pixels, preferably 128x128 pixels
- **Color:** Single color or few colors for best display

#### Step 2: Upload Icon

Upload your icon to the module's icons directory:
```
/modules_v4/burial-places-report/resources/icons/my-cemetery-icon.svg
```

#### Step 3: Adjust CSS File

1. Open the CSS file for your theme:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

2. Change the `background-image` path:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
     /* OLD: */
     /* background-image: url("../icons/menu-list-burial-webtrees.svg"); */
     
     /* NEW: */
     background-image: url("../icons/my-cemetery-icon.svg");
   }
   ```

3. Save the file and clear browser cache (Ctrl+F5)

#### Tips for Custom Icons

✅ **Recommended:**
- Simple, clear shapes (easily recognizable even at small size)
- High-contrast colors matching the theme
- Consistent style with other menu icons

❌ **Avoid:**
- Too detailed icons (become unreadable at small display)
- Too many colors
- Text in icons (poorly readable)

---

### 🆕 Option 4: Create Custom CSS File for New Theme

If you use a theme for which no CSS file exists yet, you can create your own.

#### Step 1: Determine Theme Name

1. Log in to Webtrees
2. Go to **Control panel** → **Themes**
3. Note the **exact name** of your theme (e.g., "my-custom-theme")

#### Step 2: Create CSS File

1. Copy an existing theme-specific CSS file as template:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```
   
   **IMPORTANT:** Do NOT use `menu-icons.universal.css` as template - this file has no theme classes!
   
   **Suitable templates:**
   - `menu-icons.webtrees.css` (recommended)
   - `menu-icons.colors.css`
   - `menu-icons.fab.css`
   - All others EXCEPT `menu-icons.universal.css`

2. Rename the copy according to this scheme:
   ```
   menu-icons.[THEME-NAME].css
   ```
   
   **Example:** If your theme is called "my-custom-theme":
   ```
   menu-icons.my-custom-theme.css
   ```

#### Step 3: Adjust Theme Class

1. Open your new CSS file

2. Change the comments in the header:
   ```css
   /* ============================================================
      my-custom-theme – Menu item "Burial Places"
      ============================================================
      This file ONLY works when my-custom-theme is active.
      ============================================================ */
   ```

3. **IMPORTANT:** Replace the theme name in the CSS selector throughout the file:
   
   Since you used `menu-icons.webtrees.css` as template, it says:
   ```css
   /* AS IT IS IN THE TEMPLATE: */
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
   ```
   
   Change `webtrees` to **your theme name**:
   ```css
   /* AS IT MUST BE FOR YOUR THEME: */
   .wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial {
   ```
   
   **Note:** Replace `my-custom-theme` with the **exact theme name** from Step 1.
   
   You need to make this change in **two places** in the file:
   - Once for the menu item itself (`.menu-list-burial`)
   - Once for the icon before it (`.menu-list-burial::before`)
   
   **Tip:** Use your editor's Find & Replace function:
   - Search for: `wt-theme-webtrees`
   - Replace with: `wt-theme-my-custom-theme`
   - This changes both places at once!

#### Step 4: Customize Layout and Icon

Now adjust the parameters in your CSS file:

```css
.wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial {
  position: relative;
  line-height: 1.70 !important;  /* Adapt to your theme */
  padding: 0.40rem 1rem 0.50rem 2.20em !important;
}

.wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  content: "";
  position: absolute;
  left: 0.35em;     /* Adjust horizontal position */
  top: 35%;         /* Adjust vertical position */
  transform: translateY(-50%);
  width: 1.20em;    /* Adjust icon size */
  height: 1.20em;
  background-image: url("../icons/my-icon.svg");  /* Your icon */
  background-repeat: no-repeat;
  background-size: contain;
  background-position: center;
  pointer-events: none;
}
```

#### Step 5: Test

1. Save the CSS file
2. Make sure the filename is correct: `menu-icons.[EXACT-THEME-NAME].css`
3. Clear browser cache (Ctrl+F5)
4. Check if the icon appears in the menu

**Troubleshooting:**
- No icon appears? → Check theme name in Step 1
- Icon positioned incorrectly? → Adjust `left`, `top`, `width`, `height`
- Icon overlaps text? → Increase `padding-left` in first CSS block

---

### 🔍 Troubleshooting: Icons

#### Problem: Icon is not displayed

**Quick Diagnosis (⭐ START HERE!):**

Before checking files and settings, use the module's built-in debug information:

1. **Right-click on any page** → **"View page source"**
2. **Search for** `Detected Theme:` (Ctrl+F or Cmd+F)
3. **Check the output:**

```html
<!-- Burial Places Module - Icon CSS -->
<!-- Detected Theme: _jc-theme-webtrees_ -->
<!-- Loaded CSS files: menu-icons_webtrees_.css -->
<style>
... (CSS code) ...
</style>
```

**What to check:**
- ✅ **Is theme detected?** → Should show theme name like `_jc-theme-webtrees_`
- ✅ **Is CSS file loaded?** → Should show filename like `menu-icons_webtrees_.css`
- ✅ **Is CSS code present?** → `<style>` should contain CSS rules, not be empty
- ❌ **If `Detected Theme: unknown`** → Theme not recognized!
- ❌ **If `Loaded CSS files:` is empty** → No matching CSS file found!

**Common problem example:**
```html
<!-- Detected Theme: _jc-theme-justlight_ -->
<!-- Loaded CSS files: menu-icons_universal.css -->
```
→ ❌ No `menu-icons_justlight_.css` exists → Falls back to universal.css

**Solution:** Create CSS file for your theme (see section below on creating theme CSS)

---

**Other possible causes:**

1. **Theme name does not match**
   - Solution: Check exact theme name in **Control panel** → **Themes**
   - Filename must be exact: `menu-icons.[theme-name].css`
   - **IMPORTANT:** Did you use `menu-icons.universal.css` as template? That's wrong! This file has no theme classes. Use `menu-icons.webtrees.css` as template instead and adjust the theme class.

2. **CSS file not uploaded correctly**
   - Solution: Check if file is in the right directory:
     ```
     /modules_v4/burial-places-report/resources/css/
     ```

3. **Browser cache**
   - Solution: Clear cache with **Ctrl+F5** (Windows) or **Cmd+Shift+R** (Mac)

4. **Icon path incorrect**
   - Solution: Check path in CSS file:
     ```css
     background-image: url("../icons/your-icon.svg");
     ```
   - Path is **relative** to CSS file

#### Problem: Icon is too large/small

**Solution:**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  width: 1.20em;   /* Adjust size */
  height: 1.20em;  /* Adjust size */
}
```

#### Problem: Icon overlaps text

**Solution 1:** Move text further right
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  padding-left: 2.50em !important;  /* More space for icon */
}
```

**Solution 2:** Move icon further left
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.25em;  /* Closer to left edge */
}
```

#### Problem: Icon is vertically misaligned

**Solution:**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  top: 40%;  /* Increase value = icon lower */
             /* Decrease value = icon higher */
}
```

#### Problem: Icon is not updated despite changes

**Solution:**
1. **Clear browser cache** (Ctrl+F5)
2. **Clear Webtrees cache:**
   - Control panel → Site preferences → "Clear all caches"
3. **Test another browser** (Chrome, Firefox, etc.)
4. **Test incognito mode** (bypass browser cache)

---

### 📚 Example Configurations

#### Example 1: Large icon, lots of space

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 2.20 !important;
  padding: 0.50rem 1rem 0.80rem 2.80em !important;
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.40em;
  top: 35%;
  width: 1.80em;
  height: 1.80em;
  background-image: url("../icons/my-icon.svg");
}
```

#### Example 2: Small icon, compact

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.40 !important;
  padding: 0.30rem 1rem 0.40rem 2.00em !important;
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.30em;
  top: 30%;
  width: 1.00em;
  height: 1.00em;
  background-image: url("../icons/my-icon.svg");
}
```

#### Example 3: No icon (text only)

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.50 !important;
  padding: 0.40rem 1rem !important;  /* No padding-left for icon */
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  display: none;  /* Hide icon */
}
```

---

### 💡 Best Practices for Icon Customization

1. **Use the right template for new theme CSS:**
   - ✅ Suitable: `menu-icons.webtrees.css`, `menu-icons.colors.css`, etc.
   - ❌ Unsuitable: `menu-icons.universal.css` (has no theme classes!)

2. **Always backup original CSS files** before making changes:
   ```
   menu-icons.webtrees.css → menu-icons.webtrees.css.original
   ```

3. **Test changes in a development system** before applying them to the live site

4. **Document your changes** directly in the CSS files with comments:
   ```css
   /* Modified on 2025-10-28: Icon enlarged for better visibility */
   width: 1.80em;
   ```

5. **Use theme-specific CSS files** instead of universal.css for better control

6. **Check the display on different screen sizes** (desktop, tablet, smartphone)

7. **Pay attention to accessibility**: Icons should be clearly visible even at high contrast

---

## 🔧 Compatibility

The module works with:

- ✅ Webtrees 2.2.1 to 2.2.4
- ✅ All common themes
- ✅ PHP 8.0 to 8.3
- ✅ GEDCOM files from various genealogy programs

**Tested Genealogy Programs:**
- Ahnenblatt (often uses AGNC)
- Family Tree Maker (often uses PLAC)
- Gramps (often uses NOTE)
- Legacy Family Tree
- And more

**Tested Browsers:**
- Chrome/Edge (Chromium) 90+
- Firefox 88+
- Safari 14+
- Mobile Safari (iOS 14+)
- Chrome Mobile (Android 10+)

**Tested Webtrees Themes:**
- webtrees (default theme)
- colors
- fab
- minimal
- clouds
- xenea
- And more via universal.css

---

## 🛠️ Troubleshooting

### Module does not appear in menu

**Checklist:**
1. Is the module activated? → "Control panel → Modules → All modules"
2. Is the module activated as "List page"? → "Control panel → Modules → Lists"
3. Clear cache (reload browser with Ctrl+F5)

### No cemetery information is displayed

**Solutions:**
1. Activate **diagnostic mode** in settings
2. Check if your GEDCOM files contain AGNC, PLAC, or NOTE fields for burials
3. Adjust the **keywords** to your language/data
4. Change the **fallback order** to search in the right fields first

### AGNC field is not displayed in editor

**Solution:**
Activate the option "Always show cemetery field (institution) for burials" in the module settings.

### CSV export contains no data

**Causes:**
- No burials found that match the filter criteria
- Browser blocks downloads → Check popup blocker
- Server timeout for very large family trees → Use filters to reduce data volume

### Too many "Unknown" entries

**Solutions:**
1. Activate **diagnostic mode** - You will then see (NONE) for entries without information
2. Expand the **keywords** to include additional terms
3. Change the **fallback order**
4. Use the filter "Only without cemetery information" to specifically maintain missing data

### Icon-specific problems

See section **🔍 Troubleshooting: Icons** above for detailed solutions to icon problems.

---

## 🌍 Supported Languages

The module is available in the following languages:

- 🇩🇪 **Deutsch** (de.php)
- 🇬🇧 **English** (en-GB.php)
- 🇫🇷 **Français** (fr.php)
- 🇭🇺 **Magyar** (hu.php)

The language file is automatically loaded based on the Webtrees language setting.

---

## 📞 Support

### Contact

If you have questions, problems, or suggestions for improvement:

- **Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)
- **Email:** [info@wt-module.schitho.at](mailto:info@wt-module.schitho.at)
- **Author:** Thomas Schiller (with the help of AI Sonnet)

### Helpful Resources

- [Webtrees Documentation](https://webtrees.net/)
- [Webtrees Wiki](https://wiki.genealogy.net/Webtrees_Handbuch)
- [Webtrees Forum](https://www.webtrees.net/forums/)

---

## 📜 License

This module is free software and is released under the **GNU General Public License v3.0**.

```
webtrees: online genealogy
Copyright (C) 2025 webtrees development team

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

The full license can be found at: [https://www.gnu.org/licenses/gpl-3.0.html](https://www.gnu.org/licenses/gpl-3.0.html)

---

## 🙏 Acknowledgments

- **Webtrees Team** - For the great genealogy software
- **JustCarmen** - For inspiration through other Webtrees modules
- **Anthropic Claude (Sonnet 4.5)** - For support in development

---

## 📝 Changelog

### Version 2.2.4.1.2
- 🐛 **BUG-FIX:** Universal path detection for icon display
  - **Problem:** Icons were not displayed in installations within subdirectories (e.g., `/wt-test2/`)
  - **Cause:** Hardcoded icon paths without base path (`/modules_v4/...` instead of `/wt-test2/modules_v4/...`)
  - **Solution:** Dynamic base path detection via `$_SERVER['SCRIPT_NAME']` with normalization
  - **Affected:** `module.php` - `headContent()` method (lines 149-159)
  - **Result:** Icons now work correctly in all installation scenarios (root, subdomain, subdirectory)

### Version 2.4.4.1
- ✨ Extended icon customization options
- ✨ Theme-specific CSS files for all standard themes
- ✨ Universal CSS as fallback for all themes
- ✨ Comprehensive documentation for icon customization
- ✨ Ability to display menu item without icon
- ✨ Support for custom icons (SVG, PNG, WebP)

### Version 2.4.4.0
- ✨ Intelligent fallback logic for AGNC, PLAC, and NOTE
- ✨ Configurable order of field search (drag & drop)
- ✨ Keyword filter for PLAC and NOTE fields
- ✨ Diagnostic mode to display data source
- ✨ Option "Always show AGNC field" in editor
- ✨ Dropdown filter for burials with/without cemetery information
- ✨ CSV export with all details (incl. address, note, URL)
- ✨ Tree-specific configuration
- ✨ Reset function for default values
- ✨ Validation of keyword input
- ✨ Multilingual support (DE, EN, FR, HU)
- ✨ Responsive design for mobile devices

---

**Good luck with the Burial Places Module!** 🎉
