# Bestattungsorte Modul für Webtrees

Ein Webtrees 2.2+ Custom-Modul zur intelligenten Auswertung und Darstellung von Bestattungsorten, gruppiert nach Friedhöfen und Institutionen.

## 📋 Inhaltsverzeichnis

- [Über das Modul](#über-das-modul)
- [Funktionen](#funktionen)
- [Systemanforderungen](#systemanforderungen)
- [Installation](#installation)
- [Verwendung](#verwendung)
- [Konfiguration](#konfiguration)
- [Filterlogik](#filterlogik)
- [CSV-Export](#csv-export)
- [**🎨 Icon- und Menü-Anpassung**](#icon--und-menü-anpassung) ⭐ NEU
- [Kompatibilität](#kompatibilität)
- [Unterstützte Sprachen](#unterstützte-sprachen)
- [Support](#support)
- [Lizenz](#lizenz)

---

## 🎯 Über das Modul

Das **Bestattungsorte Modul** wertet alle Bestattungsereignisse (BURI) in Deinem Stammbaum aus und gruppiert sie nach Bestattungsorten und Friedhöfen bzw. Institutionen. Das Besondere: Das Modul sucht intelligent in verschiedenen GEDCOM-Feldern (AGNC, PLAC, NOTE) nach Friedhofsinformationen - konfigurierbar für verschiedene Genealogieprogramme.

**Entwickelt von:** Thomas Schiller (mit Hilfe von KI Sonnet)  
**Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)  
**Version:** 2.2.4.1.2

---

## ✨ Funktionen

- ✅ **Intelligente Friedhofs-Erkennung** - Sucht automatisch in AGNC, PLAC oder NOTE nach Friedhofsinformationen
- ✅ **Konfigurierbare Fallback-Reihenfolge** - Du bestimmst, in welcher Reihenfolge die Felder durchsucht werden
- ✅ **Keyword-Filter** - Definiere Schlüsselwörter (z.B. "Friedhof", "Cemetery") zur Erkennung von Friedhöfen in PLAC und NOTE
- ✅ **Flexible Filterung** - Filtere nach Bestattungsort, Friedhof/Institution oder zeige nur Einträge mit/ohne Friedhofsinformation
- ✅ **Sortieroptionen** - Sortiere nach Ort oder nach Friedhof/Institution
- ✅ **CSV-Export** - Exportiere die komplette Liste mit allen Details
- ✅ **Diagnosemodus** - Zeigt an, aus welchem GEDCOM-Feld die Friedhofsinformation stammt (AGNC/PLAC/NOTE)
- ✅ **AGNC-Feld immer anzeigen** - Option, das Friedhofsfeld (Institution) im Bestattungs-Editor immer sichtbar zu machen
- ✅ **Anpassbare Menü-Icons** - Icons und Layout für jedes Theme individuell anpassbar
- ✅ **Mehrsprachig** - Deutsch, Englisch, Französisch, Ungarisch
- ✅ **Baumspezifische Einstellungen** - Jeder Stammbaum kann individuell konfiguriert werden

---

## 💻 Systemanforderungen

- **Webtrees:** Version 2.2.1 oder höher (getestet mit 2.2.4)
- **PHP:** Version 8.0 oder höher (empfohlen: 8.3+)
- **Browser:** Alle modernen Browser mit aktiviertem JavaScript
- **FTP-Zugang:** Zum Hochladen der Modul-Dateien

---

## 📦 Installation

### Schritt 1: Modul herunterladen

Lade das Modul von [https://wt-module.schitho.at](https://wt-module.schitho.at) herunter und entpacke es.

### Schritt 2: Dateien hochladen

Lade den kompletten Ordner `burial-places-report` in das Verzeichnis `/modules_v4/` Deiner Webtrees-Installation hoch.

Die Struktur sollte wie folgt aussehen:

```
webtrees/
└── modules_v4/
    └── burial-places-report/
        ├── module.php
        ├── module_helper.php
        └── resources/
            ├── lang/
            │   ├── de.php
            │   ├── en-GB.php
            │   ├── fr.php
            │   └── hu.php
            ├── views/
            │   ├── admin.phtml
            │   ├── admin-tree-select.phtml
            │   └── list-page.phtml
            ├── css/
            │   ├── menu-icons.webtrees.css
            │   ├── menu-icons.colors.css
            │   ├── menu-icons.fab.css
            │   ├── menu-icons.minimal.css
            │   ├── menu-icons.clouds.css
            │   ├── menu-icons.xenea.css
            │   └── menu-icons.universal.css
            └── icons/
                └── (verschiedene SVG-Icons)
```

### Schritt 3: Modul aktivieren

1. Melde Dich als Administrator in Webtrees an
2. Gehe zu **Verwaltung** → **Module** → **Alle Module**
3. Suche nach **"Burial Places Report"** bzw. **"Bestattungsorte"**
4. Aktiviere das Modul durch Anklicken des Schalters

### Schritt 4: Modul konfigurieren

1. Gehe zu **Verwaltung** → **Module** → **Listen**
2. Klicke bei "Bestattungsorte" auf das Zahnrad-Symbol (Einstellungen)
3. Wähle den gewünschten Stammbaum aus
4. Konfiguriere die Einstellungen nach Deinen Bedürfnissen

**Fertig!** Das Modul ist jetzt einsatzbereit!

---

## 🎨 Verwendung

### Grundlegende Nutzung

1. Gehe im Hauptmenü zu **Listen** → **Bestattungsorte**
2. Wähle optional Filter aus:
   - Bestattungsort (z.B. "Wien")
   - Friedhof/Institution (z.B. "Zentralfriedhof")
   - Nur Einträge mit/ohne Friedhofsinformation
3. Wähle die Sortierung: Nach Ort oder nach Friedhof/Institution
4. Klicke auf "Liste erstellen"
5. Die Ergebnisse werden gruppiert nach Bestattungsort und Friedhof angezeigt
6. Optional: Exportiere die Liste als CSV-Datei

### Darstellung der Ergebnisse

Die Liste zeigt:
- **Gruppierung:** Nach Bestattungsort und Friedhof/Institution
- **Personendaten:** Name, Geburt, Tod, Alter
- **Bestattungsdatum:** Datum der Bestattung
- **Anzahl:** Wie viele Personen an jedem Ort/Friedhof bestattet sind

---

## ⚙️ Konfiguration

### Admin-Einstellungen

Öffne die Modul-Einstellungen über **Verwaltung** → **Module** → **Listen** → **Bestattungsorte** (Zahnrad-Symbol).

#### 1. Friedhofsfeld im Ereignis-Editor

**Option:** "Friedhofsfeld (Institution) bei Bestattungen immer anzeigen"

Wenn aktiviert, wird das AGNC-Feld (Institution) im Bestattungs-Editor immer angezeigt und kann bearbeitet werden - auch wenn bisher kein Wert eingetragen war. Das erleichtert die Datenerfassung.

#### 2. Reihenfolge zur Werteermittlung

Das Modul kann in drei verschiedenen GEDCOM-Feldern nach Friedhofsinformationen suchen:

- **AGNC** (Institution) - Das spezialisierte Friedhofsfeld
- **NOTE** (Erste Zeile der Notiz) - Wenn Schlüsselwörter übereinstimmen
- **PLAC** (Ortsname) - Wenn Schlüsselwörter übereinstimmen

**Beispiel-Reihenfolge:**
1. Zuerst im AGNC-Feld suchen
2. Falls leer: Erste Zeile der NOTE prüfen (mit Keywords)
3. Falls leer: PLAC-Feld prüfen (mit Keywords)

Du kannst die Reihenfolge per Drag & Drop ändern.

#### 3. Friedhofs-Schlüsselwörter

Definiere Schlüsselwörter, die das Modul verwendet, um Friedhöfe in PLAC- und NOTE-Feldern zu identifizieren.

**Standard-Schlüsselwörter:**
```
Friedhof,Cemetery,Cimetière,Temető
```

**Format:** Kommagetrennt, ohne Leerzeichen

**Beispiel:** Wenn "Friedhof" als Keyword definiert ist und im PLAC-Feld "Wien, Zentralfriedhof" steht, wird "Wien, Zentralfriedhof" als Friedhof erkannt.

#### 4. Diagnosemodus

**Option:** "Quell-Tag (AGNC/NOTE/PLAC) in Klammern anzeigen"

Wenn aktiviert, siehst Du in der Liste in Klammern, aus welchem GEDCOM-Feld die Friedhofsinformation stammt:
- (AGNC) - Aus dem Institution-Feld
- (NOTE) - Aus der ersten Zeile einer Notiz
- (PLAC) - Aus dem Ortsfeld
- (NONE) - Keine Information gefunden

Dies hilft Dir, Deine GEDCOM-Daten zu überprüfen und zu optimieren.

#### 5. Auf Standardwerte zurücksetzen

Mit dem Button "Auf Standardwerte zurücksetzen" kannst Du alle Einstellungen für den aktuellen Baum auf die Werkseinstellungen zurücksetzen.

---

## 🔄 Filterlogik

### Intelligente Friedhofs-Erkennung

Das Modul durchsucht die GEDCOM-Daten in der von Dir festgelegten Reihenfolge:

**1. AGNC-Feld (Institution):**
```gedcom
1 BURI
2 AGNC Zentralfriedhof Wien
```
→ Direkter Wert wird übernommen

**2. NOTE-Feld (Erste Zeile mit Keywords):**
```gedcom
1 BURI
2 NOTE Friedhof St. Marx, Gruppe 15
```
→ Wenn "Friedhof" als Keyword definiert ist, wird die erste Zeile übernommen

**3. PLAC-Feld (Mit Keywords):**
```gedcom
1 BURI
2 PLAC Wien, Zentralfriedhof
```
→ Wenn "Friedhof" oder "Zentralfriedhof" als Keyword definiert ist, wird der Ortsname übernommen

### Bestattungsorte-Filter

Im Frontend kannst Du wählen:
- **Mit und ohne Friedhofsinformationen** - Zeigt alle Bestattungen
- **Nur mit Friedhofsinformationen** - Zeigt nur Einträge, bei denen ein Friedhof gefunden wurde
- **Nur ohne Friedhofsinformationen** - Zeigt nur Einträge ohne Friedhof (zur Datenpflege)

---

## 📄 CSV-Export

### Export-Funktion

Klicke auf "Als CSV herunterladen", um die aktuelle Liste zu exportieren.

**CSV-Spalten:**
1. Bestattungsort
2. Friedhof/Institution
3. Name
4. Sterbedatum
5. Bestattungsdatum
6. Adresse (aus BURI → ADDR)
7. Notiz (aus BURI → NOTE)
8. URL zur Personenseite

**Format:**
- Zeichensatz: UTF-8 mit BOM
- Trennzeichen: Semikolon (;)
- Textbegrenzung: Anführungszeichen (")
- Dateiname: `burial-places-[STAMMBAUM]-[DATUM].csv`

**Beispiel:** `burial-places-meier-2025-10-23.csv`

---

## 🎨 Icon- und Menü-Anpassung

### Überblick: Wie funktioniert das Icon-System?

Das Modul verwendet **theme-spezifische CSS-Dateien**, um Icons und Layout für jeden Menüpunkt optimal an das jeweilige Webtrees-Theme anzupassen. Das System funktioniert automatisch:

1. **Automatische Theme-Erkennung:** Das Modul erkennt Dein aktives Theme
2. **Theme-spezifische CSS laden:** Es lädt automatisch die passende CSS-Datei (z.B. `menu-icons.webtrees.css` für das Webtrees-Standard-Theme)
3. **Fallback-Mechanismus:** Wenn keine theme-spezifische Datei existiert, wird `menu-icons.universal.css` verwendet

**Verfügbare Theme-CSS-Dateien:**
```
resources/css/
├── menu-icons.webtrees.css     → für Webtrees-Theme
├── menu-icons.colors.css       → für Colors-Theme
├── menu-icons.fab.css          → für FAB-Theme
├── menu-icons.minimal.css      → für Minimal-Theme
├── menu-icons.clouds.css       → für Clouds-Theme
├── menu-icons.xenea.css        → für Xenea-Theme
└── menu-icons.universal.css    → Fallback für alle anderen Themes
```

**Hinweis zur universal.css:**
Diese Datei verwendet **keine Theme-Klasse** (z.B. `.wt-theme-webtrees`), sondern nur `.dropdown-item.menu-list-burial`. Dadurch funktioniert sie mit **allen** Themes, ist aber **nicht geeignet als Vorlage** für eigene theme-spezifische CSS-Dateien!

---

### ❌ Option 1: Menüpunkt OHNE Icon anzeigen

Wenn Du den Menüpunkt **ohne Icon** darstellen möchtest, gibt es zwei Möglichkeiten:

#### Methode A: CSS-Datei für Dein Theme entfernen

1. Navigiere zum Modul-Verzeichnis:
   ```
   /modules_v4/burial-places-report/resources/css/
   ```

2. Benenne die CSS-Datei für Dein Theme um oder lösche sie:
   ```
   menu-icons.webtrees.css  → menu-icons.webtrees.css.backup
   ```

3. Cache leeren (Browser: Strg+F5)

**Ergebnis:** Der Menüpunkt erscheint ohne Icon mit Standard-Webtrees-Formatierung.

#### Methode B: Icon in CSS deaktivieren

1. Öffne die CSS-Datei Deines Themes:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

2. Suche den Abschnitt mit `::before` und ändere:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
     display: none;  /* ← Füge diese Zeile hinzu */
   }
   ```

3. Passe das Padding an (optional), damit der Text nicht eingerückt ist:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
     padding: 0.40rem 1rem !important;  /* Ohne padding-left für Icon */
   }
   ```

4. Speichere die Datei und leere den Browser-Cache (Strg+F5)

---

### 🔧 Option 2: Bestehende CSS-Dateien anpassen

Du kannst Layout, Größe und Position des Icons für jedes Theme individuell anpassen.

#### Schritt 1: CSS-Datei für Dein Theme öffnen

1. Identifiziere Dein aktives Theme (z.B. "webtrees")
2. Öffne die entsprechende CSS-Datei:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

#### Schritt 2: Anpassbare Parameter

Die CSS-Dateien sind ausführlich kommentiert. Hier sind die wichtigsten Parameter:

##### 📏 **Icon-Größe anpassen**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  width: 1.50em;   /* Breite des Icons (Standard: 1.50em) */
  height: 1.50em;  /* Höhe des Icons (Standard: 1.50em) */
}
```
**Empfohlene Werte:** 0.8em (klein) bis 1.8em (groß)

##### 📍 **Icon horizontal verschieben**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.35em;  /* Abstand vom linken Rand (Standard: 0.35em) */
}
```
- **Kleiner Wert** (z.B. 0.2em) = Icon weiter links
- **Größer Wert** (z.B. 0.6em) = Icon weiter rechts

##### 📍 **Icon vertikal verschieben**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  top: 32%;  /* Vertikale Position (Standard: 32%-40%) */
}
```
- **Kleiner Wert** (z.B. 25%) = Icon höher
- **Größer Wert** (z.B. 45%) = Icon tiefer

##### 📐 **Zeilenhöhe und Abstände**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.90 !important;  /* Zeilenhöhe (Standard: 1.5-2.0) */
  padding: 0rem 1rem 0.70rem 2.20em !important;  /* oben rechts unten links */
}
```
- **line-height:** Höhere Werte = mehr Abstand zwischen Zeilen
- **padding-left:** Sollte mindestens 2.0em sein, wenn Icon angezeigt wird

#### Schritt 3: Änderungen testen

1. Speichere die CSS-Datei
2. Leere den Browser-Cache: **Strg+F5** (Windows) oder **Cmd+Shift+R** (Mac)
3. Prüfe die Darstellung im Menü

**Tipp:** Die CSS-Dateien enthalten am Ende eine ausführliche Schnellanleitung mit allen anpassbaren Parametern!

---

### 🎨 Option 3: Eigenes Icon verwenden

Du kannst das Standard-Icon durch ein eigenes Icon ersetzen.

#### Unterstützte Icon-Formate

- **SVG** (empfohlen) - Skaliert perfekt in jeder Größe
- **PNG** - Mit transparentem Hintergrund, mindestens 64x64 Pixel
- **WebP** - Moderne Alternative zu PNG

#### Schritt 1: Icon-Datei vorbereiten

1. Erstelle oder lade ein Icon im **SVG**-Format herunter
2. Benenne es sinnvoll, z.B.: `mein-friedhof-icon.svg`

**Icon-Größe-Empfehlungen:**
- **SVG:** Beliebige Größe (wird automatisch skaliert)
- **PNG:** Mindestens 64x64 Pixel, besser 128x128 Pixel
- **Farbe:** Einfarbig oder mit wenigen Farben für beste Darstellung

#### Schritt 2: Icon hochladen

Lade Dein Icon in das Icons-Verzeichnis des Moduls hoch:
```
/modules_v4/burial-places-report/resources/icons/mein-friedhof-icon.svg
```

#### Schritt 3: CSS-Datei anpassen

1. Öffne die CSS-Datei Deines Themes:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```

2. Ändere den `background-image` Pfad:
   ```css
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
     /* ALT: */
     /* background-image: url("../icons/menu-list-burial-webtrees.svg"); */
     
     /* NEU: */
     background-image: url("../icons/mein-friedhof-icon.svg");
   }
   ```

3. Speichere die Datei und leere den Browser-Cache (Strg+F5)

#### Tipps für eigene Icons

✅ **Empfohlen:**
- Einfache, klare Formen (gut erkennbar auch in kleiner Größe)
- Kontrastreiche Farben passend zum Theme
- Konsistenter Stil mit anderen Menü-Icons

❌ **Vermeiden:**
- Zu detaillierte Icons (werden bei kleiner Darstellung unleserlich)
- Zu viele Farben
- Text in Icons (schlecht lesbar)

---

### 🆕 Option 4: Eigene CSS-Datei für neues Theme erstellen

Wenn Du ein Theme verwendest, für das noch keine CSS-Datei existiert, kannst Du eine eigene erstellen.

#### Schritt 1: Theme-Namen ermitteln

1. Melde Dich in Webtrees an
2. Gehe zu **Verwaltung** → **Themes**
3. Notiere Dir den **exakten Namen** Deines Themes (z.B. "my-custom-theme")

#### Schritt 2: CSS-Datei erstellen

1. Kopiere eine bestehende theme-spezifische CSS-Datei als Vorlage:
   ```
   /modules_v4/burial-places-report/resources/css/menu-icons.webtrees.css
   ```
   
   **WICHTIG:** Verwende NICHT `menu-icons.universal.css` als Vorlage - diese Datei hat keine Theme-Klassen!
   
   **Geeignete Vorlagen:**
   - `menu-icons.webtrees.css` (empfohlen)
   - `menu-icons.colors.css`
   - `menu-icons.fab.css`
   - Alle anderen AUSSER `menu-icons.universal.css`

2. Benenne die Kopie nach diesem Schema:
   ```
   menu-icons.[THEME-NAME].css
   ```
   
   **Beispiel:** Wenn Dein Theme "my-custom-theme" heißt:
   ```
   menu-icons.my-custom-theme.css
   ```

#### Schritt 3: Theme-Klasse anpassen

1. Öffne Deine neue CSS-Datei

2. Ändere die Kommentare im Header:
   ```css
   /* ============================================================
      my-custom-theme – Menüpunkt "Bestattungsorte"
      ============================================================
      Diese Datei wirkt NUR, wenn das my-custom-theme aktiv ist.
      ============================================================ */
   ```

3. **WICHTIG:** Ersetze in der gesamten Datei den Theme-Namen im CSS-Selektor:
   
   Da Du `menu-icons.webtrees.css` als Vorlage verwendet hast, steht dort:
   ```css
   /* SO IST ES IN DER VORLAGE: */
   .wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
   ```
   
   Ändere `webtrees` in **Deinen Theme-Namen**:
   ```css
   /* SO MUSS ES FÜR DEIN THEME SEIN: */
   .wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial {
   ```
   
   **Hinweis:** Ersetze `my-custom-theme` durch den **exakten Theme-Namen** aus Schritt 1.
   
   Diese Änderung musst Du an **zwei Stellen** in der Datei vornehmen:
   - Einmal für den Menüpunkt selbst (`.menu-list-burial`)
   - Einmal für das Icon davor (`.menu-list-burial::before`)
   
   **Tipp:** Nutze die Suchen & Ersetzen Funktion Deines Editors:
   - Suche nach: `wt-theme-webtrees`
   - Ersetze durch: `wt-theme-my-custom-theme`
   - Damit änderst Du beide Stellen auf einmal!

#### Schritt 4: Layout und Icon anpassen

Passe nun die Parameter in Deiner CSS-Datei an:

```css
.wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial {
  position: relative;
  line-height: 1.70 !important;  /* An Dein Theme anpassen */
  padding: 0.40rem 1rem 0.50rem 2.20em !important;
}

.wt-theme-my-custom-theme .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  content: "";
  position: absolute;
  left: 0.35em;     /* Horizontale Position anpassen */
  top: 35%;         /* Vertikale Position anpassen */
  transform: translateY(-50%);
  width: 1.20em;    /* Icon-Größe anpassen */
  height: 1.20em;
  background-image: url("../icons/mein-icon.svg");  /* Dein Icon */
  background-repeat: no-repeat;
  background-size: contain;
  background-position: center;
  pointer-events: none;
}
```

#### Schritt 5: Testen

1. Speichere die CSS-Datei
2. Stelle sicher, dass der Dateiname korrekt ist: `menu-icons.[EXAKTER-THEME-NAME].css`
3. Leere den Browser-Cache (Strg+F5)
4. Prüfe, ob das Icon im Menü erscheint

**Fehlersuche:**
- Erscheint kein Icon? → Prüfe den Theme-Namen in Schritt 1
- Icon falsch positioniert? → Passe `left`, `top`, `width`, `height` an
- Icon überschneidet Text? → Erhöhe `padding-left` im ersten CSS-Block

---

### 🔍 Troubleshooting: Icons

#### Problem: Icon wird nicht angezeigt

**Schnelldiagnose (⭐ HIER STARTEN!):**

Bevor Du Dateien und Einstellungen prüfst, nutze die eingebauten Debug-Informationen des Moduls:

1. **Rechtsklick auf einer beliebigen Seite** → **"Seitenquelltext anzeigen"**
2. **Suche nach** `Detected Theme:` (Strg+F oder Cmd+F)
3. **Prüfe die Ausgabe:**

```html
<!-- Burial Places Module - Icon CSS -->
<!-- Detected Theme: _jc-theme-webtrees_ -->
<!-- Loaded CSS files: menu-icons_webtrees_.css -->
<style>
... (CSS-Code) ...
</style>
```

**Was Du prüfen solltest:**
- ✅ **Theme erkannt?** → Sollte Theme-Namen zeigen wie `_jc-theme-webtrees_`
- ✅ **CSS-Datei geladen?** → Sollte Dateinamen zeigen wie `menu-icons_webtrees_.css`
- ✅ **CSS-Code vorhanden?** → `<style>` sollte CSS-Regeln enthalten, nicht leer sein
- ❌ **Wenn `Detected Theme: unknown`** → Theme nicht erkannt!
- ❌ **Wenn `Loaded CSS files:` leer ist** → Keine passende CSS-Datei gefunden!

**Häufiges Problem-Beispiel:**
```html
<!-- Detected Theme: _jc-theme-justlight_ -->
<!-- Loaded CSS files: menu-icons_universal.css -->
```
→ ❌ Es existiert keine `menu-icons_justlight_.css` → Fallback auf universal.css

**Lösung:** Erstelle CSS-Datei für Dein Theme (siehe Abschnitt unten zum Erstellen von Theme-CSS)

---

**Weitere mögliche Ursachen:**

1. **Theme-Name stimmt nicht überein**
   - Lösung: Prüfe den exakten Theme-Namen in **Verwaltung** → **Themes**
   - Der Dateiname muss exakt sein: `menu-icons.[theme-name].css`
   - **WICHTIG:** Hast Du `menu-icons.universal.css` als Vorlage verwendet? Das ist falsch! Diese Datei hat keine Theme-Klassen. Verwende stattdessen `menu-icons.webtrees.css` als Vorlage und passe die Theme-Klasse an.

2. **CSS-Datei nicht richtig hochgeladen**
   - Lösung: Prüfe, ob die Datei im richtigen Verzeichnis liegt:
     ```
     /modules_v4/burial-places-report/resources/css/
     ```

3. **Browser-Cache**
   - Lösung: Leere den Cache mit **Strg+F5** (Windows) oder **Cmd+Shift+R** (Mac)

4. **Icon-Pfad falsch**
   - Lösung: Prüfe den Pfad in der CSS-Datei:
     ```css
     background-image: url("../icons/dein-icon.svg");
     ```
   - Der Pfad ist **relativ** zur CSS-Datei

#### Problem: Icon ist zu groß/klein

**Lösung:**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  width: 1.20em;   /* Größe anpassen */
  height: 1.20em;  /* Größe anpassen */
}
```

#### Problem: Icon überschneidet den Text

**Lösung 1:** Text weiter nach rechts verschieben
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  padding-left: 2.50em !important;  /* Mehr Platz für Icon */
}
```

**Lösung 2:** Icon weiter nach links verschieben
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.25em;  /* Näher am linken Rand */
}
```

#### Problem: Icon ist vertikal falsch ausgerichtet

**Lösung:**
```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  top: 40%;  /* Wert erhöhen = Icon tiefer */
             /* Wert verringern = Icon höher */
}
```

#### Problem: Icon wird nicht aktualisiert trotz Änderungen

**Lösung:**
1. **Browser-Cache leeren** (Strg+F5)
2. **Webtrees-Cache leeren:**
   - Verwaltung → Bereinigung → "Alle Caches leeren"
3. **Anderen Browser testen** (Chrome, Firefox, etc.)
4. **Inkognito-Modus testen** (Browser-Cache umgehen)

---

### 📚 Beispiel-Konfigurationen

#### Beispiel 1: Großes Icon, viel Abstand

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 2.20 !important;
  padding: 0.50rem 1rem 0.80rem 2.80em !important;
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.40em;
  top: 35%;
  width: 1.80em;
  height: 1.80em;
  background-image: url("../icons/mein-icon.svg");
}
```

#### Beispiel 2: Kleines Icon, kompakt

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.40 !important;
  padding: 0.30rem 1rem 0.40rem 2.00em !important;
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  left: 0.30em;
  top: 30%;
  width: 1.00em;
  height: 1.00em;
  background-image: url("../icons/mein-icon.svg");
}
```

#### Beispiel 3: Kein Icon (nur Text)

```css
.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial {
  line-height: 1.50 !important;
  padding: 0.40rem 1rem !important;  /* Kein padding-left für Icon */
}

.wt-theme-webtrees .wt-genealogy-menu .dropdown-item.menu-list-burial::before {
  display: none;  /* Icon ausblenden */
}
```

---

### 💡 Best Practices für Icon-Anpassungen

1. **Verwende die richtige Vorlage für neue Theme-CSS:**
   - ✅ Geeignet: `menu-icons.webtrees.css`, `menu-icons.colors.css`, etc.
   - ❌ Ungeeignet: `menu-icons.universal.css` (hat keine Theme-Klassen!)

2. **Sichere immer die Original-CSS-Dateien** vor Änderungen:
   ```
   menu-icons.webtrees.css → menu-icons.webtrees.css.original
   ```

3. **Teste Änderungen in einem Entwicklungssystem** bevor Du sie auf der Live-Seite anwendest

4. **Dokumentiere Deine Änderungen** direkt in den CSS-Dateien mit Kommentaren:
   ```css
   /* Angepasst am 2025-10-28: Icon vergrößert für bessere Sichtbarkeit */
   width: 1.80em;
   ```

5. **Verwende theme-spezifische CSS-Dateien** statt universal.css für bessere Kontrolle

6. **Prüfe die Darstellung auf verschiedenen Bildschirmgrößen** (Desktop, Tablet, Smartphone)

7. **Achte auf Barrierefreiheit**: Icons sollten auch bei hohem Kontrast gut erkennbar sein

---

## 🔧 Kompatibilität

Das Modul funktioniert mit:

- ✅ Webtrees 2.2.1 bis 2.2.4
- ✅ Allen gängigen Themes
- ✅ PHP 8.0 bis 8.3
- ✅ GEDCOM-Dateien von verschiedenen Genealogieprogrammen

**Getestete Genealogieprogramme:**
- Ahnenblatt (nutzt oft AGNC)
- Family Tree Maker (nutzt oft PLAC)
- Gramps (nutzt oft NOTE)
- Legacy Family Tree
- Und weitere

**Getestete Browser:**
- Chrome/Edge (Chromium) 90+
- Firefox 88+
- Safari 14+
- Mobile Safari (iOS 14+)
- Chrome Mobile (Android 10+)

**Getestete Webtrees-Themes:**
- webtrees (Standard-Theme)
- colors
- fab
- minimal
- clouds
- xenea
- Und weitere über universal.css

---

## 🛠️ Fehlerbehebung

### Modul erscheint nicht im Menü

**Checkliste:**
1. Ist das Modul aktiviert? → "Verwaltung → Module → Alle Module"
2. Ist das Modul als "Listenseite" aktiviert? → "Verwaltung → Module → Listen"
3. Cache löschen (Browser neu laden mit Strg+F5)

### Keine Friedhofsinformationen werden angezeigt

**Lösungen:**
1. Aktiviere den **Diagnosemodus** in den Einstellungen
2. Prüfe, ob Deine GEDCOM-Dateien AGNC, PLAC oder NOTE-Felder bei Bestattungen enthalten
3. Passe die **Schlüsselwörter** an Deine Sprache/Daten an
4. Ändere die **Fallback-Reihenfolge**, um zuerst in den richtigen Feldern zu suchen

### AGNC-Feld wird im Editor nicht angezeigt

**Lösung:**
Aktiviere in den Modul-Einstellungen die Option "Friedhofsfeld (Institution) bei Bestattungen immer anzeigen".

### CSV-Export enthält keine Daten

**Ursachen:**
- Keine Bestattungen gefunden, die den Filterkriterien entsprechen
- Browser blockiert Downloads → Popup-Blocker prüfen
- Server-Timeout bei sehr großen Stammbäumen → Verwende Filter, um die Datenmenge zu reduzieren

### Zu viele "Unbekannt"-Einträge

**Lösungen:**
1. Aktiviere den **Diagnosemodus** - Du siehst dann (NONE) bei Einträgen ohne Information
2. Erweitere die **Schlüsselwörter** um weitere Begriffe
3. Ändere die **Fallback-Reihenfolge**
4. Nutze den Filter "Nur ohne Friedhofsinformationen", um gezielt fehlende Daten nachzupflegen

### Icon-spezifische Probleme

Siehe Abschnitt **🔍 Troubleshooting: Icons** weiter oben für detaillierte Lösungen zu Icon-Problemen.

---

## 🌍 Unterstützte Sprachen

Das Modul ist in folgenden Sprachen verfügbar:

- 🇩🇪 **Deutsch** (de.php)
- 🇬🇧 **English** (en-GB.php)
- 🇫🇷 **Français** (fr.php)
- 🇭🇺 **Magyar** (hu.php)

Die Sprachdatei wird automatisch basierend auf der Webtrees-Spracheinstellung geladen.

---

## 📞 Support

### Kontakt

Wenn Du Fragen, Probleme oder Verbesserungsvorschläge hast:

- **Website:** [https://wt-module.schitho.at](https://wt-module.schitho.at)
- **E-Mail:** [info@wt-module.schitho.at](mailto:info@wt-module.schitho.at)
- **Autor:** Thomas Schiller (mit Hilfe von KI Sonnet)

### Hilfreiche Ressourcen

- [Webtrees Dokumentation](https://webtrees.net/)
- [Webtrees Wiki](https://wiki.genealogy.net/Webtrees_Handbuch)
- [Webtrees Forum](https://www.webtrees.net/forums/)

---

## 📜 Lizenz

Dieses Modul ist freie Software und wird unter der **GNU General Public License v3.0** veröffentlicht.

```
webtrees: online genealogy
Copyright (C) 2025 webtrees development team

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

Die vollständige Lizenz findest Du unter: [https://www.gnu.org/licenses/gpl-3.0.html](https://www.gnu.org/licenses/gpl-3.0.html)

---

## 🙏 Danksagungen

- **Webtrees Team** - Für die großartige Genealogie-Software
- **JustCarmen** - Für Inspiration durch andere Webtrees-Module
- **Anthropic Claude (Sonnet 4.5)** - Für die Unterstützung bei der Entwicklung

---

## 📝 Changelog

### Version 2.2.4.1.2
- 🐛 **BUG-FIX:** Universelle Pfad-Erkennung für Icon-Darstellung
  - **Problem:** Icons wurden nicht angezeigt bei Installationen in Unterverzeichnissen (z.B. `/wt-test2/`)
  - **Ursache:** Hardcodierte Icon-Pfade ohne Base-Path (`/modules_v4/...` statt `/wt-test2/modules_v4/...`)
  - **Lösung:** Dynamische Base-Path-Ermittlung über `$_SERVER['SCRIPT_NAME']` mit Normalisierung
  - **Betroffen:** `module.php` - `headContent()` Methode (Zeilen 149-159)
  - **Ergebnis:** Icons funktionieren nun in allen Installationsszenarien (Root, Subdomain, Unterverzeichnis)

### Version 2.4.4.1
- ✨ Erweiterte Icon-Anpassungsmöglichkeiten
- ✨ Theme-spezifische CSS-Dateien für alle Standard-Themes
- ✨ Universal-CSS als Fallback für alle Themes
- ✨ Ausführliche Dokumentation für Icon-Anpassungen
- ✨ Möglichkeit, Menüpunkt ohne Icon darzustellen
- ✨ Unterstützung für eigene Icons (SVG, PNG, WebP)

### Version 2.4.4.0
- ✨ Intelligente Fallback-Logik für AGNC, PLAC und NOTE
- ✨ Konfigurierbare Reihenfolge der Feldsuche (Drag & Drop)
- ✨ Keyword-Filter für PLAC und NOTE-Felder
- ✨ Diagnosemodus zur Anzeige der Datenquelle
- ✨ Option "AGNC-Feld immer anzeigen" im Editor
- ✨ Dropdown-Filter für Bestattungen mit/ohne Friedhofsinformation
- ✨ CSV-Export mit allen Details (inkl. Adresse, Notiz, URL)
- ✨ Baumspezifische Konfiguration
- ✨ Reset-Funktion für Standardwerte
- ✨ Validierung der Keyword-Eingabe
- ✨ Mehrsprachige Unterstützung (DE, EN, FR, HU)
- ✨ Responsive Design für mobile Geräte

---

**Viel Erfolg mit dem Bestattungsorte Modul!** 🎉
